<?php
session_start();
include('connection.php');

// Assuming $_SESSION['admin_login'] holds the username of the admin logged in
$admin_username = $_SESSION['admin_login'];

// Fetch admin details
$query = "SELECT admin_fullname, admin_username, admin_gender, admin_role FROM admin WHERE admin_username = ?";
$stmt = $con->prepare($query);
$stmt->bind_param("s", $admin_username);
$stmt->execute();
$result = $stmt->get_result();
$admin_details = $result->fetch_assoc();

// Fetch past papers details
$query1 = "SELECT * FROM pastpapers";
$sql = mysqli_query($con, $query1);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Past Papers List</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .table-avatar {
            width: 50px;
            height: 50px;
            border-radius: 50%;
        }
    </style>
</head>
<body>

    <!-- Header with Search and User Info -->
    <nav class="navbar navbar-light bg-light">
        <div class="container-fluid">
            <form class="d-flex">
                <input class="form-control me-2" type="search" id="searchInput" placeholder="Search by subject, year, exam type..." aria-label="Search">
                <button class="btn btn-outline-success" type="button" onclick="searchTable()">Search</button>
            </form>
            <div class="d-flex">
                <span class="navbar-text">Administrator</span>
                <img src="uploads/geofrey.jpg" alt="Admin Image" class="ms-3 rounded-circle" style="height:40px; width:40px; cursor:pointer;" id="adminImage">
            </div>
        </div>
    </nav>

    <!-- Modal for Admin Details -->
    <div class="modal fade" id="adminDetailsModal" tabindex="-1" aria-labelledby="adminDetailsLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="adminDetailsLabel">Admin Details</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p><strong>Full Name:</strong> <?php echo $admin_details['admin_fullname']; ?></p>
                    <p><strong>Username:</strong> <?php echo $admin_details['admin_username']; ?></p>
                    <p><strong>Gender:</strong> <?php echo $admin_details['admin_gender']; ?></p>
                    <p><strong>Role:</strong> <?php echo $admin_details['admin_role']; ?></p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <div class="container mt-5">
        <h4 class="mb-3">Past Papers List</h4>

        <!-- Table to Display the Data -->
        <table class="table table-bordered table-hover" id="dataTable">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Form</th>
                    <th>Subject</th>
                    <th>Exam Type</th>
                    <th>Year</th>
                    <th>Uploaded By</th>
                    <th>Paper</th>
                    <th>Marking Scheme</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php
                if ($sql->num_rows > 0) {
                    $i = 1;
                    while($row = $sql->fetch_assoc()) {
                        echo "<tr>";
                        echo "<td>" . $i++ . "</td>";
                        ?>
                        <td><?php echo $row['form']; ?></td>
                        <td><?php echo ucfirst($row['subject']); ?></td>
                        <td><?php echo ucfirst($row['exam_type']); ?></td>
                        <td><?php echo $row['year']; ?></td>
                        <td><?php echo $row['poster_name']; ?></td>
                        <td><a href="<?php echo $row['paper_file']; ?>" class="btn btn-primary" download>Download Paper</a></td>
                        <td><a href="<?php echo $row['marking_scheme_file']; ?>" class="btn btn-secondary" download>Download Marking Scheme</a></td>
                            <td>
                            <a href="school_viewpaperdetails.php?paper_id=<?php echo $row['id']; ?>" class="btn btn-primary">View</a>
                             </td>
                             <td>
                            <a href="school_editpaper.php?paper_id=<?php echo $row['id']; ?>" class="btn btn-warning">Edit</a>
                             </td>
                             <td>
                            <a href="javascript:void(0)" onclick="confirmDelete('<?php echo $row['id']; ?>')" class="btn btn-danger">Delete</a>
                             </td>
                       
                        <?php
                        echo "</tr>";
                    }
                } else {
                    echo "<tr><td colspan='9'>No records found</td></tr>";
                }
                ?>
            </tbody>
        </table>
    </div>

    <!-- Footer -->
    <footer class="bg-light text-center py-3">
        <p>&copy; <span id="currentYear"></span> Examination Portal | Powered by GM Technologies</p>
    </footer>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.min.js"></script>

    <!-- Dynamic Year -->
    <script>
        document.getElementById("currentYear").textContent = new Date().getFullYear();

        // JavaScript function for filtering table rows
        function searchTable() {
            let input = document.getElementById("searchInput");
            let filter = input.value.toUpperCase();
            let table = document.getElementById("dataTable");
            let tr = table.getElementsByTagName("tr");

            // Loop through all table rows, and hide those that don't match the search query
            for (let i = 1; i < tr.length; i++) {
                let td = tr[i].getElementsByTagName("td");
                let match = false;
                for (let j = 0; j < td.length; j++) {
                    if (td[j]) {
                        if (td[j].innerText.toUpperCase().indexOf(filter) > -1) {
                            match = true;
                            break;
                        }
                    }
                }
                tr[i].style.display = match ? "" : "none";
            }
        }

        // Function to show admin details modal on image click
        document.getElementById('adminImage').addEventListener('click', function () {
            var modal = new bootstrap.Modal(document.getElementById('adminDetailsModal'));
            modal.show();
        });

        // AJAX function for deleting a paper
        function confirmDelete(paper_id) {
            if (confirm("Are you sure you want to delete this paper?")) {
                var xhr = new XMLHttpRequest();
                xhr.open("GET", "school_deletepaper.php?paper_id=" + paper_id, true);
                xhr.onload = function () {
                    if (xhr.status == 200) {
                        var response = xhr.responseText;
                        if (response.includes('success')) {
                            alert('Paper successfully deleted.');
                            location.reload();
                        } else {
                            alert('Failed to delete the paper. ' + response);
                        }
                    } else {
                        alert('Error in deleting paper. Try again.');
                    }
                };
                xhr.send();
            }
        }
    </script>
</body>
</html>

<?php
$con->close();
?>
